/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.images.VWImageLoader;
import filenet.vw.toolkit.design.property.tables.VWMilestoneUsageItem;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class VWMilestoneUsageListCellRenderer
extends JLabel
implements ListCellRenderer {
    private ImageIcon m_preIcon = null;
    private ImageIcon m_postIcon = null;
    private ImageIcon m_prePostIcon = null;

    public VWMilestoneUsageListCellRenderer() {
        try {
            this.setOpaque(true);
            this.m_preIcon = VWImageLoader.createImageIcon("premilestone.gif");
            this.m_postIcon = VWImageLoader.createImageIcon("postmilestone.gif");
            this.m_prePostIcon = VWImageLoader.createImageIcon("prepostmilestone.gif");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        try {
            if (value != null) {
                VWMilestoneUsageItem item = (VWMilestoneUsageItem)value;
                this.setFont(list.getFont());
                this.setEnabled(list.isEnabled());
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                if (item.isAfter() && item.isBefore()) {
                    this.setIcon(this.m_prePostIcon);
                } else if (item.isAfter()) {
                    this.setIcon(this.m_postIcon);
                } else if (item.isBefore()) {
                    this.setIcon(this.m_preIcon);
                }
                this.setText(item.getStepName());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this;
    }
}

